import { calculerMoyenneNotes, trierLivresParMoyenne } from "../services/livres.service";
import { LivreModel, OrdreTri } from "../models";

const livres: LivreModel[] = [
    {
        titre: 'Les misérables',
        auteur: 'Victor Hugo',
        genres: ["Roman historique", "Drame"],
        datePublication: 1862,
        notes: [5, 4, 5, 3],
        img: "/images/default.jpeg",
        prix: 3,
        selectionne: false
    },
    {
        titre: "L'Homme qui rit",
        auteur: 'Victor Hugo',
        genres: ["Drame", "Roman philosophique"],
        datePublication: 1869,
        notes: [4, 1],
        img: "/images/rit.jpg",
        prix: 16,
        selectionne: false
    },
    {
        titre: "Crime and Punishment",
        auteur: 'Fyodor Dostoevsky',
        genres: ["Psychologie", "Drame"],
        datePublication: 1866,
        notes: [],
        img: "/images/crime.jpg",
        prix: 3,
        selectionne: false
    }
];


export const TestQuestion5 = ({ ordre }: { ordre: OrdreTri }) => {

    const livresTries = trierLivresParMoyenne(livres, ordre);
    const ordreTri = ordre === OrdreTri.ASC ? "croissant" : "décroissant";
    console.log(`Tri par ordre ${ordreTri}`);
    livresTries.forEach((livre) => {
        const calculMoyenne = calculerMoyenneNotes(livre);
        const noteMoyenne = calculMoyenne == null ? "livre non noté" : calculMoyenne.toString();
        console.log(`   
                        Titre : ${livre.titre}
                        Auteur : ${livre.auteur}
                        Genres : ${livre.genres.join(", ")}
                        Date de publication : ${livre.datePublication}
                        Notes : ${livre.notes.join(", ")}
                        Note Moyenne : ${noteMoyenne}
                        Image : ${livre.img}
                        Prix : ${livre.prix}
                        Selectionne : ${livre.selectionne}
                    `);
    });

    return (
        <div className="App">
            <h2>Test Question 5</h2>
            <p>Il faut vérifier le résultat dans la console</p>
        </div>
    );
}