import { calculerMoyenneNotes } from "../services/livres.service";
import { LivreModel } from "../models";

const livres: LivreModel[] = [
    {
        titre: 'Les misérables',
        auteur: 'Victor Hugo',
        genres: ["Roman historique", "Drame"],
        datePublication: 1862,
        notes: [5, 4, 5, 3],
        img: "images/miserables.jpg",
        prix: 3,
        selectionne: false
    },
    {
        titre: "L'Homme qui rit",
        auteur: 'Victor Hugo',
        genres: ["Drame", "Roman philosophique"],
        datePublication: 1869,
        notes: [4, 1],
        img: "images/rit.jpg",
        prix: 16,
        selectionne: false
    },
    {
        titre: "Crime and Punishment",
        auteur: 'Fyodor Dostoevsky',
        genres: ["Psychologie", "Drame"],
        datePublication: 1866,
        notes: [],
        img: "images/crime.jpg",
        prix: 3,
        selectionne: false
    }
];


export const TestQuestion4 = () => {

    livres.forEach((livre) => {
        const moyenne = calculerMoyenneNotes(livre);
        console.log(`Moyenne des notes pour "${livre.titre}" : ${moyenne}`);
    });

    return (
        <div className="App">
            <h2>Test Question 4</h2>
            <p>Il faut vérifier le résultat dans la console.</p>
        </div>
    );
}