import React, { useEffect } from "react";
import { getOeuvres } from "../services/livres.service";
import { LivreModel } from "../models";

interface TestQuestion3Props {
    auteur: string;
}

export const TestQuestion3: React.FC<TestQuestion3Props> = ({ auteur }) => {

    useEffect(() => {
        const fetchLivre = async () => {
            try {
                const fetchedLivres: LivreModel[] = await getOeuvres(auteur); // Appel de la fonction getOeuvres
            
                console.log("Liste des livres trouvés :");
                fetchedLivres.forEach((livre) => {
                    console.log(`
                        Titre : ${livre.titre}
                        Auteur : ${livre.auteur}
                        Genres : ${livre.genres.join(", ")}
                        Date de publication : ${livre.datePublication}
                        Notes : ${livre.notes.join(", ")}
                        Image : ${livre.img}
                        Prix : ${livre.prix}
                        Sélectionné : ${livre.selectionne}
                    `);
                });
            } catch (err) {            
                console.error(err);
            }
        };

        fetchLivre();
    }, []); 


    return (
        <div className="App">
            <h2>Test Question 3</h2>
            <p>Il faut vérifier le résultat dans la console.</p>
        </div>
    );
}