import React, { useEffect} from "react";
import { getLivre } from "../services/livres.service";
import { LivreModel } from "../models";

interface TestQuestion2Props {
    titreLivre: string; 
  }

export const TestQuestion2: React.FC<TestQuestion2Props> = ({ titreLivre }) => {

    useEffect(() => {
        const fetchLivre = async () => {
          try {
            const fetchedLivre : LivreModel = await getLivre(titreLivre); // Appel de la fonction getLivre            
            console.log(`
              Résumé du livre :
              Titre : ${fetchedLivre.titre}
              Auteur : ${fetchedLivre.auteur}
              Genres : ${fetchedLivre.genres.join(", ")}
              Date de publication : ${fetchedLivre.datePublication}
              Notes : ${fetchedLivre.notes.join(", ")}
              Image : ${fetchedLivre.img}
              Prix : ${fetchedLivre.prix} 
              Selectioné : ${fetchedLivre.selectionne}              
            `);
          } catch (err) {            
            console.error(err);
          }
        };
    
        fetchLivre();
      }, []);

    return (
        <div className="App">
            <h2>Test Question 2</h2>
            <p>Il faut vérifier le résultat dans la console</p>
        </div>
    );
}