import React from "react";
import './Toggle.css';

interface ToggleProps {
    selectionne: boolean;
    callBack: (newValue: boolean) => void;
}

const Toggle: React.FC<ToggleProps> = ({ selectionne, callBack }) => {
    const handleClick = () => {
        callBack(!selectionne);
    };

    return (
        <button
            className={`toggle-button`}
            onClick={handleClick}
        >
            {selectionne ? "Cliquer pour désélectionner" : "Cliquer pour sélectionner"}
        </button>
    );
};

export default Toggle;
