import React from 'react';
import { LivreModel } from '../models';
import './LivreCard.css';
import { calculerMoyenneNotes } from '../services/livres.service';
import Etoiles from './Etoiles';
const BASE_URL = import.meta.env.VITE_API_SERVEUR;
type LivreProps = {
  livre: LivreModel;
}

const LivreCard: React.FC<LivreProps> = ({ livre }) => {
  let moyenneNotes = calculerMoyenneNotes(livre);
  

  return (
    <div className={`livre-card`}>
      <div className="livre-card__content">
        <h2 className="livre-card__titre"></h2>
        <img src="" alt={livre.titre} className="livre-card__image" />
        <p className="livre-card__auteur">Par </p>
        <p className="livre-card__genres">
          Genres : <span></span>
        </p>
        <p className="livre-card__datePublication">Publié en </p>        
        
        {/* INSERER ICI LE COMPOSANT Etoiles */}
        
        <p className="livre-card__prix">Prix : €</p>
        <p className="livre-card__selectionne">
          
        </p>
      </div>
    </div>
  );
};

export default LivreCard; // Ici on a un seul `export default`